local pn = ...;
assert(pn);

local t = Def.ActorFrame{};

local IsUsingSoloSingles = PREFSMAN:GetPreference('Center1Player');
local NumPlayers = GAMESTATE:GetNumPlayersEnabled();
local NumSides = GAMESTATE:GetNumSidesJoined();

local function GetPosition(pn)
	if IsUsingSoloSingles and NumPlayers == 1 and NumSides == 1 then return SCREEN_CENTER_X; end;

	local strPlayer = (NumPlayers == 1) and "OnePlayer" or "TwoPlayers";
	local strSide = (NumSides == 1) and "OneSide" or "TwoSides";
	return THEME:GetMetric("ScreenGameplay","Player".. playername(pn) .. strPlayer .. strSide .."X");
end;

t[#t+1] = AutoText("frutiger")..{
	Text="Full Combo!";
	InitCommand=cmd(shadowlength,0;diffuse,PlayerColor(pn);strokecolor,PlayerDarkColor(pn);draworder,98);
	BeginCommand=function(self)
		self:diffusealpha(0);
		self:x( GetPosition(pn) );
		-- xxx: designed for normal scroll (aka not reverse)
		self:y(SCREEN_CENTER_Y*1.35);
	end;
	OffCommand=function(self)
		local pStats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
		local bFullCombo = false;
		local tnsComboThreshold = THEME:GetMetric("Gameplay","MinScoreToContinueCombo");
		if SSC then
			-- sm-ssc has FullComboOfScore(tns)
			bHasFullCombo = stats:FullComboOfScore(tnsComboThreshold)
		else
			-- alpha 6 has various IsFullComboW* bindings.
			if GetStepManiaAlphaVersion() >= 6 then
				local FullComboFuncs = {
					TapNoteScore_W1 = stats:IsFullComboW1(),
					TapNoteScore_W2 = stats:IsFullComboW2(),
					TapNoteScore_W3 = stats:IsFullComboW3(),
					TapNoteScore_W4 = stats:IsFullComboW4(),
					-- only goes up to W4
				};
				bHasFullCombo = FullComboFuncs[tnsComboThreshold];
			else
				-- alpha 5 and below supports FullCombo().
				bHasFullCombo = stats:FullCombo();
			end;
		end;
		if bFullCombo then
			self:accelerate(0.25);
			self:diffusealpha(1);
			self:glow( color("1,1,1,0.75") );
			self:zoom(1.5);
			self:decelerate(0.75);
			self:glow( color("1,1,1,0") );
			self:zoom(1);
			self:sleep(2);
			self:decelerate(0.2);
			self:diffusealpha(0);
		end;
	end;
};

return t;